% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.glmm.R
\name{stat.glmm}
\alias{stat.glmm}
\title{Extracts statistical measures of interest in Generalized Linear Mixed Models}
\usage{
stat.glmm(ant, formula, family, oda = NULL, progress = TRUE, ncores = 1, ...)
}
\arguments{
\item{ant}{an output of ANT function \code{\link{perm.net.nl}} with random factor stated, or output of ANT 'met' categories functions in which output of ANT functions \code{\link{perm.ds.focal}}, \code{\link{perm.ds.grp}} or \code{\link{perm.net.lk}} where multiple matrices have been used.}

\item{formula}{two-sided linear formula object describing both the fixed-effects and random-effects part of the model, with the response on the left of a ~ operator and the terms, separated by + operators, on the right. Random-effects terms are distinguished by vertical bars (|) separating expressions for design matrices from grouping factors. Two vertical bars (||) can be used to specify multiple uncorrelated random effects for the same grouping variable. (Because of the way it is implemented, the ||-syntax works only for design matrices containing numeric (continuous) predictors; to fit models with independent categorical effects, see dummy or the lmer_alt function from the afex package.).}

\item{family}{a GLM family, see \code{\link[stats]{glm}} and \code{\link[stats]{family}}.}

\item{oda}{the original data frame of associations when argument ant is obtained with perm.ds.grp or perm.ds.focal ANT functions.}

\item{progress}{a boolean indicating the visualization of the permutation process.}

\item{ncores}{an integer indicating the number of jobs to create for parallelization.}

\item{...}{Extra arguments for \code{\link[lme4]{lmer}} or \code{\link[lme4]{glmer}} function only.}
}
\value{
Returns a list of 3 elements :
\itemize{
\item An object of class \code{\link[lme4]{merMod}} (more specifically, an object of subclass lmerMod or glmerMod), for which many methods are available (e.g. methods(class="merMod")).
\item A data frame if the estimates of the permuted models.
\item A vector of integers indicating the permutations that returned model errors or warnings (e.g. model convergence issues) and for which new permutations were done.
}
}
\description{
Performs Generalized Linear Mixed Models tests
}
\details{
GLMM with permutation data.
}
\examples{
# Creating temporal data--------------------------
m2=matrix(sample(sim.m),20,20)
diag(m2)=0
colnames(m2)=colnames(sim.m)
row.names(m2)=row.names(sim.m)
df2=sim.df
df2$age=df2$age+1
df1=sim.df
df1$period=rep(1,nrow(df1))
df2$period=rep(2,nrow(df2))
# Data structure for multiple matrices analytical protocol------------------
sim.lm=list(sim.m,m2)
sim.ldf=list(df1,df2)
# Computing network metric---------------------------------------------------
t=met.strength(sim.lm,sim.ldf,1)
# Node label permutations---------------------------------------------------
t=perm.net.nl(t,labels='age',rf="period",nperm=10,progress=FALSE) 
# Permuted GLMM-------------------------------------------------------------
r.glmm=stat.glmm(ant = t,formula = strength ~ age + (1|id),family = gaussian(), progress=TRUE)
# Rstudio parallelization.----------------------------
 \dontrun{r.glmm=stat.glmm(t,formula = strength ~ age + (1|id),family = gaussian(), ncores = 10)}
}
\seealso{
\code{\link[lme4]{lmer}} or \code{\link[lme4]{glmer}}
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
