% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.double.grp.R
\name{perm.double.grp}
\alias{perm.double.grp}
\title{Data stream permutation for association data}
\usage{
perm.double.grp(
  obs,
  scan,
  ctrlf = NULL,
  nperm,
  progress = TRUE,
  index = "sri",
  measure,
  test = "median",
  df = NULL,
  dfid = NULL,
  rf,
  ...
)
}
\arguments{
\item{obs}{a data frame of gambit of the group observations. The data frame must have a column named 'ID'.}

\item{scan}{an integer indicating the column of scans of individual associations in obs.}

\item{ctrlf}{A confounding factor by which to control group associationsin obs.}

\item{nperm}{number of permutations to perform.}

\item{progress}{a boolean indicating if the permutation process must be visible.}

\item{index}{Which type of index of associations to calculate:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x \div x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}

\item{measure}{a character indicating the social network measure to compute (Only those available in ANTs)}

\item{test}{a character indicating the test to realize to account for the social network measure}

\item{df}{a data frame of individual characteristics in which store permutations.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{rf}{an integer (column id) or a string (column name) indicating the column holding the factor grouping multiple networks in argument \emph{df}.}

\item{...}{Additional arguments related to the social network measure to compute (argument measure).}
}
\value{
list of square association index matrices. The first element of the list is the non-permuted association index matrix.
}
\description{
Pre-network permutation on association data for gambit of the group data collection protocol. The data frame must have a column named 'ID'.
}
\details{
Data stream permutation is a pre-network permutation approach. It is used on association data based on the gambit of the group.
}
\examples{
head(sim.grp)
t=perm.double.grp(sim.grp, 'location', 'time', 10, measure = "met.strength")
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
