% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.lp.R
\name{met.lp}
\alias{met.lp}
\title{Laplacian centrality}
\usage{
met.lp(M, df = NULL, dfid = NULL, binary = FALSE)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{binary}{a boolean indicating the version of the Laplacian index, if TRUE it computes the binary version.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{Laplacian centrality} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{Laplacian centrality} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{Laplacian centrality} if argument\emph{df} is not \emph{NULL}. The name of the column is adapted according to argument value \emph{binary}.
\item A list of arguments df with a new column for nodes \emph{Laplacian centrality} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}.The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the symmetric version of Laplacian centrality for each vertex.
}
\details{
Laplacian centrality is the drop in the Laplacian energy of the graph when a vertex is removed.
This version uses the degrees (for the binary version) or the strength (for the weighted version) to calculate Laplacian centrality.
}
\examples{
met.lp(sim.m)
head(sim.df)
met.lp(sim.m,df=sim.df)
}
\references{
Qi, X., Fuller, E., Wu, Q., Wu, Y., & Zhang, C. Q. (2012). Laplacian centrality: A new centrality measure for weighted networks. Information Sciences, 194, 240-253.

Qi, X., Duval, R. D., Christensen, K., Fuller, E., Spahiu, A., Wu, Q., ... & Zhang, C. (2013). Terrorist networks, network energy and node removal: A new measure of centrality based on Laplacian energy. Social Networking, 2(01), 19.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
