% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.GE.single.R
\name{met.ge.single}
\alias{met.ge.single}
\title{Global efficiency}
\usage{
met.ge.single(
  m,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE,
  out = TRUE
)
}
\arguments{
\item{m}{a square adjacency matrix.}

\item{weighted}{if \emph{false}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the higher met.strength as the shortest path.}

\item{normalization}{normalizes the weigths of the links i.e. divides them by the average strength of the network.}

\item{directed}{if \emph{false}, it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers}
}
\value{
An interger representing the global efficiency.
}
\description{
Calculates the global efficiency of a network.
}
\details{
The global efficiency provides a measure of how efficiently information is exchanged in a network. It can be calculated in binary or weighted networks, and for undirected or directed networks. Depending on the problematic, care is needed for the choice of calculation method (binary or weighted, directed or undirected, and using the lowest or the highest met.strength as shortest path).
}
\references{
Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
\keyword{internal}
