% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/med.test.R
\name{med.test}
\alias{med.test}
\title{Perform Median test}
\usage{
med.test(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 1000,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Numeric vector of same length as y}

\item{y}{Numeric vector, or factor of same length as x}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{med.test()} performs the Median test and is used in chapters 6 and 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.7 from "Applied Nonparametric Statistical Methods" (5th edition)
med.test(ch6$males, ch6$females)

# Example 7.5 from "Applied Nonparametric Statistical Methods" (5th edition)
med.test(ch7$time, ch7$surgeon, do.exact = FALSE, do.asymp = TRUE)

}
