% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jonckheere.terpstra.R
\name{jonckheere.terpstra}
\alias{jonckheere.terpstra}
\title{Perform Jonckheere-Terpstra test}
\usage{
jonckheere.terpstra(
  x,
  g,
  alternative = c("less", "greater"),
  max.exact.cases = 15,
  nsims.mc = 10000,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.mc = FALSE,
  do.asymp.ties.adjust = TRUE
)
}
\arguments{
\item{x}{Numeric vector or factor of same length as g}

\item{g}{Factor of same length as x}

\item{alternative}{Type of alternative hypothesis (defaults to \code{c("less","greater")})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{15})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}

\item{do.asymp.ties.adjust}{Boolean indicating whether or not to use adjustment for ties in data (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{jonckheere.terpstra()} performs the Jonckheere-Terpstra test and is used in chapters 7, 8 and 12 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 7.3 from "Applied Nonparametric Statistical Methods" (5th edition)
jonckheere.terpstra(ch7$dementia.age, ch7$features, alternative = "greater",
  do.exact = FALSE, do.asymp = TRUE, do.asymp.ties.adjust = FALSE)

# Exercise 12.6 from "Applied Nonparametric Statistical Methods" (5th edition)
jonckheere.terpstra(ch12$ethnic.group, ch12$diabetes.status, do.exact = FALSE, do.asymp = TRUE)

}
