% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_antimicrobials.R
\name{key_antimicrobials}
\alias{key_antimicrobials}
\alias{all_antimicrobials}
\alias{antimicrobials_equal}
\title{(Key) Antimicrobials for First Weighted Isolates}
\usage{
key_antimicrobials(
  x = NULL,
  col_mo = NULL,
  universal = c("ampicillin", "amoxicillin/clavulanic acid", "cefuroxime",
    "piperacillin/tazobactam", "ciprofloxacin", "trimethoprim/sulfamethoxazole"),
  gram_negative = c("gentamicin", "tobramycin", "colistin", "cefotaxime", "ceftazidime",
    "meropenem"),
  gram_positive = c("vancomycin", "teicoplanin", "tetracycline", "erythromycin",
    "oxacillin", "rifampin"),
  antifungal = c("anidulafungin", "caspofungin", "fluconazole", "miconazole", "nystatin",
    "voriconazole"),
  only_sir_columns = FALSE,
  ...
)

all_antimicrobials(x = NULL, only_sir_columns = FALSE, ...)

antimicrobials_equal(
  y,
  z,
  type = c("points", "keyantimicrobials"),
  ignore_I = TRUE,
  points_threshold = 2,
  ...
)
}
\arguments{
\item{x}{a \link{data.frame} with antibiotics columns, like \code{AMX} or \code{amox}. Can be left blank to determine automatically}

\item{col_mo}{column name of the names or codes of the microorganisms (see \code{\link[=as.mo]{as.mo()}}) - the default is the first column of class \code{\link{mo}}. Values will be coerced using \code{\link[=as.mo]{as.mo()}}.}

\item{universal}{names of \strong{broad-spectrum} antimicrobial drugs, case-insensitive. Set to \code{NULL} to ignore. See \emph{Details} for the default antimicrobial drugs}

\item{gram_negative}{names of antibiotic drugs for \strong{Gram-positives}, case-insensitive. Set to \code{NULL} to ignore. See \emph{Details} for the default antibiotic drugs}

\item{gram_positive}{names of antibiotic drugs for \strong{Gram-negatives}, case-insensitive. Set to \code{NULL} to ignore. See \emph{Details} for the default antibiotic drugs}

\item{antifungal}{names of antifungal drugs for \strong{fungi}, case-insensitive. Set to \code{NULL} to ignore. See \emph{Details} for the default antifungal drugs}

\item{only_sir_columns}{a \link{logical} to indicate whether only columns must be included that were transformed to class \code{sir} (see \code{\link[=as.sir]{as.sir()}}) on beforehand (default is \code{FALSE})}

\item{...}{ignored, only in place to allow future extensions}

\item{y, z}{\link{character} vectors to compare}

\item{type}{type to determine weighed isolates; can be \code{"keyantimicrobials"} or \code{"points"}, see \emph{Details}}

\item{ignore_I}{\link{logical} to indicate whether antibiotic interpretations with \code{"I"} will be ignored when \code{type = "keyantimicrobials"}, see \emph{Details}}

\item{points_threshold}{minimum number of points to require before differences in the antibiogram will lead to inclusion of an isolate when \code{type = "points"}, see \emph{Details}}
}
\description{
These functions can be used to determine first weighted isolates by considering the phenotype for isolate selection (see \code{\link[=first_isolate]{first_isolate()}}). Using a phenotype-based method to determine first isolates is more reliable than methods that disregard phenotypes.
}
\details{
The \code{\link[=key_antimicrobials]{key_antimicrobials()}} and \code{\link[=all_antimicrobials]{all_antimicrobials()}} functions are context-aware. This means that the \code{x} argument can be left blank if used inside a \link{data.frame} call, see \emph{Examples}.

The function \code{\link[=key_antimicrobials]{key_antimicrobials()}} returns a \link{character} vector with 12 antimicrobial results for every isolate. The function \code{\link[=all_antimicrobials]{all_antimicrobials()}} returns a \link{character} vector with all antimicrobial drug results for every isolate. These vectors can then be compared using \code{\link[=antimicrobials_equal]{antimicrobials_equal()}}, to check if two isolates have generally the same antibiogram. Missing and invalid values are replaced with a dot (\code{"."}) by \code{\link[=key_antimicrobials]{key_antimicrobials()}} and ignored by \code{\link[=antimicrobials_equal]{antimicrobials_equal()}}.

Please see the \code{\link[=first_isolate]{first_isolate()}} function how these important functions enable the 'phenotype-based' method for determination of first isolates.

The default antimicrobial drugs used for \strong{all rows} (set in \code{universal}) are:
\itemize{
\item Ampicillin
\item Amoxicillin/clavulanic acid
\item Cefuroxime
\item Ciprofloxacin
\item Piperacillin/tazobactam
\item Trimethoprim/sulfamethoxazole
}

The default antimicrobial drugs used for \strong{Gram-negative bacteria} (set in \code{gram_negative}) are:
\itemize{
\item Cefotaxime
\item Ceftazidime
\item Colistin
\item Gentamicin
\item Meropenem
\item Tobramycin
}

The default antimicrobial drugs used for \strong{Gram-positive bacteria} (set in \code{gram_positive}) are:
\itemize{
\item Erythromycin
\item Oxacillin
\item Rifampin
\item Teicoplanin
\item Tetracycline
\item Vancomycin
}

The default antimicrobial drugs used for \strong{fungi} (set in \code{antifungal}) are:
\itemize{
\item Anidulafungin
\item Caspofungin
\item Fluconazole
\item Miconazole
\item Nystatin
\item Voriconazole
}
}
\examples{
# `example_isolates` is a data set available in the AMR package.
# See ?example_isolates.

# output of the `key_antimicrobials()` function could be like this:
strainA <- "SSSRR.S.R..S"
strainB <- "SSSIRSSSRSSS"

# those strings can be compared with:
antimicrobials_equal(strainA, strainB, type = "keyantimicrobials")
# TRUE, because I is ignored (as well as missing values)

antimicrobials_equal(strainA, strainB, type = "keyantimicrobials", ignore_I = FALSE)
# FALSE, because I is not ignored and so the 4th [character] differs

\donttest{
if (require("dplyr")) {
  # set key antibiotics to a new variable
  my_patients <- example_isolates \%>\%
    mutate(keyab = key_antimicrobials(antifungal = NULL)) \%>\% # no need to define `x`
    mutate(
      # now calculate first isolates
      first_regular = first_isolate(col_keyantimicrobials = FALSE),
      # and first WEIGHTED isolates
      first_weighted = first_isolate(col_keyantimicrobials = "keyab")
    )

  # Check the difference in this data set, 'weighted' results in more isolates:
  sum(my_patients$first_regular, na.rm = TRUE)
  sum(my_patients$first_weighted, na.rm = TRUE)
}
}
}
\seealso{
\code{\link[=first_isolate]{first_isolate()}}
}
