% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availability.R
\name{availability}
\alias{availability}
\title{Check Availability of Columns}
\usage{
availability(tbl, width = NULL)
}
\arguments{
\item{tbl}{a \link{data.frame} or \link{list}}

\item{width}{number of characters to present the visual availability - the default is filling the width of the console}
}
\value{
\link{data.frame} with column names of \code{tbl} as row names
}
\description{
Easy check for data availability of all columns in a data set. This makes it easy to get an idea of which antimicrobial combinations can be used for calculation with e.g. \code{\link[=susceptibility]{susceptibility()}} and \code{\link[=resistance]{resistance()}}.
}
\details{
The function returns a \link{data.frame} with columns \code{"resistant"} and \code{"visual_resistance"}. The values in that columns are calculated with \code{\link[=resistance]{resistance()}}.
}
\examples{
availability(example_isolates)
\donttest{
if (require("dplyr")) {
  example_isolates \%>\%
    filter(mo == as.mo("Escherichia coli")) \%>\%
    select_if(is.sir) \%>\%
    availability()
}
}
}
