% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abname.R
\name{abname}
\alias{abname}
\title{Name of an antibiotic}
\source{
\code{\link{antibiotics}}
}
\usage{
abname(abcode, from = c("guess", "atc", "certe", "umcg"),
  to = "official", textbetween = " + ", tolower = FALSE)
}
\arguments{
\item{abcode}{a code or name, like \code{"AMOX"}, \code{"AMCL"} or \code{"J01CA04"}}

\item{from, to}{type to transform from and to. See \code{\link{antibiotics}} for its column names. WIth \code{from = "guess"} the from will be guessed from \code{"atc"}, \code{"certe"} and \code{"umcg"}. When using \code{to = "atc"}, the ATC code will be searched using \code{\link{as.atc}}.}

\item{textbetween}{text to put between multiple returned texts}

\item{tolower}{return output as lower case with function \code{\link{tolower}}.}
}
\description{
Convert antibiotic codes to a (trivial) antibiotic name or ATC code, or vice versa. This uses the data from \code{\link{antibiotics}}.
}
\details{
\strong{The \code{\link{ab_property}} functions are faster and more concise}, but do not support concatenated strings, like \code{abname("AMCL+GENT"}.
}
\section{WHOCC}{

\if{html}{\figure{logo_who.png}{options: height=60px style=margin-bottom:5px} \cr}
This package contains \strong{all ~500 antimicrobial drugs} and their Anatomical Therapeutic Chemical (ATC) codes, ATC groups and Defined Daily Dose (DDD) from the World Health Organization Collaborating Centre for Drug Statistics Methodology (WHOCC, \url{https://www.whocc.no}) and the Pharmaceuticals Community Register of the European Commission (\url{http://ec.europa.eu/health/documents/community-register/html/atc.htm}).

These have become the gold standard for international drug utilisation monitoring and research.

The WHOCC is located in Oslo at the Norwegian Institute of Public Health and funded by the Norwegian government. The European Commission is the executive of the European Union and promotes its general interest.
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
abname("AMCL")
# "Amoxicillin and beta-lactamase inhibitor"

# It is quite flexible at default (having `from = "guess"`)
abname(c("amox", "J01CA04", "Trimox", "dispermox", "Amoxil"))
# "Amoxicillin" "Amoxicillin" "Amoxicillin" "Amoxicillin" "Amoxicillin"

# Multiple antibiotics can be combined with "+".
# The second antibiotic will be set to lower case when `tolower` was not set:
abname("AMCL+GENT", textbetween = "/")
# "amoxicillin and enzyme inhibitor/gentamicin"

abname(c("AMCL", "GENT"))
# "Amoxicillin and beta-lactamase inhibitor" "Gentamicin"

abname("AMCL", to = "trivial_nl")
# "Amoxicilline/clavulaanzuur"

abname("AMCL", to = "atc")
# "J01CR02"

# specific codes for University Medical Center Groningen (UMCG):
abname("J01CR02", from = "atc", to = "umcg")
# "AMCL"

# specific codes for Certe:
abname("J01CR02", from = "atc", to = "certe")
# "amcl"
}
\keyword{ab}
\keyword{antibiotics}
