% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods-amModelLib.R
\docType{methods}
\name{methods-amModelLib}
\alias{$,amModelLib-method}
\alias{[,amModelLib,ANY,ANY,ANY-method}
\alias{[,amModelLib-method}
\alias{[[,amModelLib,ANY,ANY-method}
\alias{[[,amModelLib-method}
\alias{[[<-,amModelLib,ANY,ANY-method}
\alias{[[<-,amModelLib-method}
\alias{c,amModelLib-method}
\alias{methods-amModelLib}
\alias{show,amModelLib-method}
\alias{summary,amModelLib-method}
\title{Methods for displaying, summarizing, and manipulating \code{amModelLib} objects}
\usage{
\S4method{summary}{amModelLib}(object, name, ...)

\S4method{show}{amModelLib}(object)

\S4method{c}{amModelLib}(x, ..., recursive = FALSE)

\S4method{[}{amModelLib,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{amModelLib,ANY,ANY}(x, i)

\S4method{$}{amModelLib}(x, name)

\S4method{[[}{amModelLib,ANY,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{object}{An \code{amModelLib} object.}

\item{name}{For \code{$} A literal character string or a name (possibly backtick quoted); for \code{summary} an \code{amModel} or \code{amData} name as character string.}

\item{x}{An \code{amModelLib} object.}

\item{recursive}{Iterate recursively through lists (ignored)}

\item{i,j}{indices specifying elements to extract or replace. Indices are numeric or character vectors or empty (missing) or NULL.}

\item{drop}{Not used.}

\item{value}{Replacement value.}

\item{\dots}{Additional arguments passed to other functions or methods.}
}
\value{
\code{summary} returns a list with the same elements displayed during the call. Others return an \code{amModelLib} object.
}
\description{
Methods for displaying, summarizing, and manipulating \code{amModelLib} objects
}
\details{
Summary adds the metadata to the default show method. If \code{name} is supplied the call is passed on to the \code{amModel} or \code{amData} object with the specified name.
}
\examples{
# create dataset from lm helpfile
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1) # omitting intercept

#' # create an amData object that includes metadata
plant.data <- data.frame(group = group, weight = weight)
plant.data <- amData(
    data = plant.data,
    comment = 'Dataset from lm helpfile.'
)

log.plant.data <- data.frame(group, log.weight=log(weight))
log.plant.data <- amData(
    data = log.plant.data,
    comment = 'data to fit log model',
    source = 'lm helpfile (R).'
)

# create two amModel objects with metadata and a soft link to the data
full.model <- amModel(
    model = lm.D9,
    comment = 'full model',
    source = 'lm helpfile (R).',
    taxa = 'plants',
    data = 'plant.data'
)

no.int.model <- amModel(
    model = lm.D90,
    comment = 'model without intercept',
    source = 'lm helpfile (R).',
    taxa = 'plants',
    data = 'plant.data'
)



# create an amModelLib that contains the two amModel objects and two amData objects
# the models and data must be supplied as named lists
mymodels <- amModelLib(
    models = list(
        full.model = full.model,
        no.int.model = no.int.model
    ),
    data=list(
        plant.data = plant.data,
        log.plant.data = log.plant.data
    )
)

summary(mymodels)
mymodels <- c(mymodels, mymodels)
mymodels[c(2,1)]
mymodels[[1]]
mymodels[['full.model']]
mymodels$full.model
}
\keyword{methods}

