% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VersionManager.R
\docType{methods}
\name{installVersion}
\alias{installVersion}
\title{Install specific AMAPVox version on local computer.}
\usage{
installVersion(version, overwrite = FALSE)
}
\arguments{
\item{version, }{a valid and existing AMAPVox remote version number
(major.minor.build)}

\item{overwrite, }{whether existing local installation should be re-installed.}
}
\value{
the path of the AMAPVox installation directory.
}
\description{
Install specific AMAPVox version on your computer.
AMAPVox versions are installed in the user-specific data
directory, as specified by \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}.
You should not worry to call directly this function since
local installations are automatically handled by the version manager
when you launch AMAPVox GUI with \code{\link[=gui]{gui()}} function.
}
\examples{
\dontrun{
# install latest version
installVersion(tail(getRemoteVersions()$version, 1))
}
}
\seealso{
\code{\link[=getLocalVersions]{getLocalVersions()}}, \code{\link[=getRemoteVersions]{getRemoteVersions()}}, \code{\link[=removeVersion]{removeVersion()}}

\code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
}
