% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_info.R, R/images.R
\name{images}
\alias{images}
\title{Retrieve image information using image ids, with an option to download}
\usage{
images(id, download = FALSE, download_path, verbose = ala_config()$verbose)

images(id, download = FALSE, download_path, verbose = ala_config()$verbose)
}
\arguments{
\item{id}{character: IDs of images to be downloaded as single string or
vector of strings}

\item{download}{logical: if TRUE download all images and add location to
dataframe}

\item{download_path}{string: (optional) filepath to download images to.
If not given and download param is TRUE, will create an images
folder}

\item{verbose}{logical: show additional progress information?
[default is set by ala_config()]}
}
\value{
Data frame of image results
}
\description{
Retrieve image information using image ids, with an option to download
}
\examples{
\dontrun{
## Retrieve infomation about an image and download
images(id="da5fe120-e213-4cd6-9c5f-62346ed2e466", download=TRUE)
}
}
\references{
\itemize{
\item Associated ALA web service for images \url{https://images.ala.org.au/ws}
}
}
