% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{show.sam}
\alias{show.sam}
\title{Show scattering analysis of microscopy (SAM) object}
\usage{
show.sam(object)
}
\arguments{
\item{object}{an S4 object of class \code{SAM}}
}
\value{
Show a list of important parameters in class \code{SAM}.
}
\description{
Function to print the \code{SAM} class object after the \code{SAM} model has
been constructed.
}
\examples{
library(AIUQ)

## Simulate BM and get estimated parameters using BM model
# Simulation
sim_bm = simulation(sz=100,len_t=100,sigma_bm=0.5)
show(sim_bm)

# AIUQ method: fitting using BM model
sam = SAM(sim_object=sim_bm)
show(sam)

}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
