% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR3d.R
\name{spatial3d_mirror}
\alias{spatial3d_mirror}
\title{Mirror Spatial 3D Reasoning Item}
\usage{
spatial3d_mirror(obj, angle = pi/1.3, x = 0.3, y = 3, z = 0.8,
  axis = TRUE)
}
\arguments{
\item{obj}{An object with class of threeD.}

\item{angle, x, y, z}{See details}

\item{axis}{Showing the axis is helpful when first testing the function.}
}
\value{
\describe{
\item{figure}{Return the matrix that generates the mirror image of the display figure.}
    }
}
\description{
This function generates the mirror image of the 3 dimensional display figure. It acts as a wrap because the creation of the figure is done using functions from the rgl package.
}
\details{
For 3D figures, some of the cubes may be hidden in sight when automatically generated. Hence, one would need to rotate the display figure several times to ensure that none of the cubes are hidden.

The arguments angle, x, y, z represents the rotation of angle radians based on the x, y and z axis. This is a wrapper to the rotationMatrix function from the rgl package. Changing the values in the arguments angle, x, y, z coordinates allows one to programmatically change angles to study potential cognitive operators at work.

You can also rotate the figure interactively by clicking on the figure and moving it in different direction.
}
\examples{
display <- spatial3d(seed=4, angle=pi/1.3, x=0.3,y=4,z=0.8,axis = TRUE)
display_mirror <- spatial3d_mirror(display, angle=pi/1.3, x=0.3,y=4,z=0.8,axis = TRUE)

# To save the figure (not run)
# library(rgl)
# display_mirror <- spatial3d_mirror(display, angle=pi/1.3, x=0.3,y=4,z=0.8,axis = TRUE)
# wd<- '~/desktop'

# save in pdf
# item <- 1
# save <- paste0(wd,"/mirror3d_",item,".pdf")
# rgl.postscript(save,"pdf")

# save in png
# rgl.snapshot(filename="image3D.png",fmt="png")

}
\references{
\url{https://en.wikipedia.org/wiki/Radian}

Bejar, I. I. (1990). A generative analysis of a three-dimensional spatial task. \emph{Applied Psychological Measurement}, 14(3), 237-245.
}
\seealso{
\code{\link{lisy}}, \code{\link{arith}}, \code{\link{spatial2d}}, \code{\link{spatial3d}}
}
\author{
Aiden Loe
}
