% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AICc_permanova2.R
\name{AICc_permanova2}
\alias{AICc_permanova2}
\title{Calculate AICc for a permutational multivariate analysis of variance (PERMANOVA)}
\usage{
AICc_permanova2(adonis2_model)
}
\arguments{
\item{adonis2_model}{An object of class adonis2 from the vegan package}
}
\value{
A data frame with the AICc, the number of parameters (k) and the number of observations (N).
}
\description{
#' This function calculates the Akaike's Information Criterion (AICc) for a permutational multivariate analysis of variance (PERMANOVA) model. The AICc is a modified version of the Akaike Information Criterion (AIC) that is more appropriate for small sample sizes and high-dimensional models.
}
\details{
The AICc calculation for a PERMANOVA model is:

\deqn{AICc = AIC + \frac{2k(k+1)}{n-k-1}}{AICc = AIC + (2k(k+1))/(n-k-1)}

where AIC is the Akaike Information Criterion, k is the number of parameters in the model (excluding the intercept), and n is the number of observations.
}
\examples{

library(vegan)
data(dune)
data(dune.env)

# Run PERMANOVA using adonis2

Model <- adonis2(dune ~ Management*A1, data = dune.env)

# Calculate AICc
AICc_permanova2(Model)

}
\references{
Zuur, A. F., Ieno, E. N., Walker, N. J., Saveliev, A. A., & Smith, G. M. (2009). Mixed effects models and extensions in ecology with R. Springer Science & Business Media.
}
\seealso{
\code{\link{adonis2}}
}
\keyword{models}
