% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reintegrate.R
\name{reintegrate}
\alias{reintegrate}
\alias{reintegrate_legacy}
\title{Reintegrate ActiGraph data}
\usage{
reintegrate(
  ag,
  target_sec,
  time_var = "Timestamp",
  method = c("tidy", "legacy"),
  ...
)

reintegrate_legacy(
  ag,
  target_sec,
  time_var = "Timestamp",
  direction = c("forwards", "backwards"),
  verbose = FALSE
)
}
\arguments{
\item{ag}{a data frame to reintegrate}

\item{target_sec}{the desired epoch length of the output. Starting epoch
length will be determined automatically}

\item{time_var}{The name of the column containing POSIX-formatted timestamp
information}

\item{method}{character scalar indicating the desired method of
reintegration. Options are \code{tidy} (the default) and \code{legacy}. See
details}

\item{...}{arguments passed to \code{reintegrate_legacy}}

\item{direction}{The direction of reintegration, i.e. whether a timestamp
refers to the timespan after the previous data point ("backwards"), or
before the next data point ("forwards").}

\item{verbose}{logical. Print updates to console?}
}
\value{
A data frame of reintegrated activity count data
}
\description{
Reintegrate ActiGraph data
}
\details{
Two methods are provided. One is a legacy method that allows "forward" or
"backward" reintegration, depending on whether the timestamp occurs
(respectively) at the start of the interval (typical for activity monitors)
or the end (typical for indirect calorimeters). The other is a \code{tidy}
approach, which is both more straightforward and more concise. However,
runtime implications are uncertain, and only forward reintegration is
supported (consistent with 'ActiLife' precedent).
}
\examples{

test_file <- system.file(
  "extdata", "example1sec.csv", package = "AGread"
)

ag <- read_AG_counts(test_file, header = TRUE)

# Old Method:

  old_result <- reintegrate(
    ag = ag,
    target_sec = 60,
    time_var = "Timestamp",
    method = "legacy",
    direction = c("forwards")
  )

# New Method:

  new_result <- reintegrate(ag, 60)

}
