% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gt3x_legacy_dev_compare.R
\name{legacy_dev_compare}
\alias{legacy_dev_compare}
\title{Verify \code{\link{read_gt3x}} gives equivalent output using legacy and dev
parsers}
\usage{
legacy_dev_compare(file, time = FALSE, verbose = FALSE)
}
\arguments{
\item{file}{path to the gt3x file for use in comparing the parsers}

\item{time}{logical. Should timing information be returned?}

\item{verbose}{logical. Print updates to console?}
}
\value{
If \code{time = FALSE} (default), a logical scalar is returned,
  indicating whether the outputs matched. If \code{time = TRUE}, run times
  are returned for both parsers.
}
\description{
Verify \code{\link{read_gt3x}} gives equivalent output using legacy and dev
parsers
}
\examples{
\donttest{
file_3x <- system.file(
  "extdata", "example.gt3x", package = "AGread"
)
legacy_dev_compare(file_3x)
}
}
