% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Counts.R
\name{read_AG_counts}
\alias{read_AG_counts}
\title{Read data table files containing count values}
\usage{
read_AG_counts(file, verbose = FALSE, skip = 10, nrows = 10,
  header = FALSE, ...)
}
\arguments{
\item{file}{A character scalar giving path to an automatically-generated csv
file with count values}

\item{verbose}{A logical scalar: Print processing updates?}

\item{skip}{Header length: Number of rows to skip when reading the file}

\item{nrows}{Header length: Number of rows to read when retrieving meta-data}

\item{header}{A logical scalar: Are variable names contained in first row of
file?}

\item{...}{Further arguments passed to \code{read.csv} and \code{fread}}
}
\value{
A data frame reflecting the data contained in the csv file
}
\description{
Read data table files containing count values
}
\examples{
read_AG_counts(
  system.file(
    "extdata",
    "example1sec.csv",
    package = "AGread"
  ),
  skip = 11
)

}
