% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLoops.R
\name{loopTillConvergence}
\alias{loopTillConvergence}
\title{Loop testAllSigMatrices until convergence}
\usage{
loopTillConvergence(
  numLoops,
  fastStop,
  exprData,
  changePer,
  handMetaCluster,
  testOnHalf
)
}
\arguments{
\item{numLoops}{The number of iterations. Set to null to loop until results converge.}

\item{fastStop}{Set to TRUE to break the loop when correlation, correlation spear, mae and rmse all converge}

\item{exprData}{The single cell matrix}

\item{changePer}{The maximum percentage of change allowed for convergence}

\item{handMetaCluster}{A List of pre-defined meta clusters. Set to NULL to automatically group indistinguishable 
cells into same cluster use clustWspillOver (DEFAULT: NULL)}

\item{testOnHalf}{Set to TRUE to leave half the data as a test set to validate all the matrices}
}
\value{
A list of results generated from all the iterative calls of testAllSigMatrices

A list of results generated from all the iterative calls of testAllSigMatrices
}
\description{
Iteratively call testAllSigMatrices numLoops times with the option to fast stop 
 if correlation, correlation spear, mae and rmse all converge
}
\examples{
ct1 <- runif(1000, 0, 100)
ct2 <- runif(1000, 0, 100)
ct3 <- runif(1000, 0, 100)
ct4 <- runif(1000, 0, 100)
dataMat <- cbind(ct1, ct1, ct1, ct1, ct1, ct1, ct2, ct2, ct2, ct2, ct3, ct3, ct3,ct3,ct4,ct4)
rownames(dataMat) <- make.names(rep('gene', nrow(dataMat)), unique=TRUE)
noise <- matrix(runif(nrow(dataMat)*ncol(dataMat), -2, 2), nrow = nrow(dataMat), byrow = TRUE)
dataMat <- dataMat + noise
#options(mc.cores=2)
#  This is a meta-function that calls other functions, 
#  The execution speed is too slow for the CRAN automated check
#loopTillConvergence(numLoops=10, fastStop=TRUE, exprData=dataMat, 
#    changePer=10,handMetaCluster=NULL, testOnHalf=TRUE)
}
