% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLoops.R
\name{buildSeed}
\alias{buildSeed}
\title{Build a deconvolution seed matrix, add the proportional option}
\usage{
buildSeed(
  trainSet,
  genesInSeed = 200,
  groupSize = 30,
  randomize = TRUE,
  num.trees = 1000,
  plotIt = TRUE,
  trainSet.3sam = NULL,
  trainSet.30sam = NULL,
  proportional = FALSE
)
}
\arguments{
\item{trainSet}{Each row is a gene, and each column is an example of a particular cell type, ie from single cell data}

\item{genesInSeed}{The maximum number of genes in the returned seed matrix (DEFAULT: 200)}

\item{groupSize}{The number of groups to break the trainSet into by ADAPTS::scSample (DEFAULT: 30)}

\item{randomize}{Set to TRUE randomize the sets selected by ADAPTS::scSample (DEFAULT: TRUE)}

\item{num.trees}{The number of trees to be used by ranger (DEFAULT: 1000)}

\item{plotIt}{Set to TRUE to plot (DEFAULT: TRUE)}

\item{trainSet.3sam}{Optional pre-calculated ADAPTS::scSample(trainSet, groupSize = 3) (DEFAULT: NULL)}

\item{trainSet.30sam}{Optional pre-calculated ADAPTS::scSample(trainSet, groupSize=groupSize, randomize=randomize) (DEFAULT: NULL)}

\item{proportional}{Set to true to make the training set cell type proportional.  Ignores group size (DEFAULT: FALSE)}
}
\value{
A list with condition numbers and gene lists
}
\description{
Use ranger to select features and build a genesInSeed gene matrix
}
\examples{
library(ADAPTS)
ct1 <- runif(1000, 0, 100)
ct2 <- runif(1000, 0, 100)
dataMat <- cbind(ct1, ct1, ct1, ct1, ct1, ct1, ct2, ct2, ct2, ct2)
rownames(dataMat) <- make.names(rep('gene', nrow(dataMat)), unique=TRUE)
noise <- matrix(runif(nrow(dataMat)*ncol(dataMat), -2, 2), nrow = nrow(dataMat), byrow = TRUE)
dataMat <- dataMat + noise
newSigMat <- buildSeed(trainSet=dataMat)

}
