% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anaconda.functions.R
\name{taxon_mwu_list}
\alias{taxon_mwu_list}
\title{taxon_mwu_list}
\usage{
taxon_mwu_list(
  inFile,
  goAnnotations,
  goDivision,
  level1 = 0.1,
  level2 = 0.05,
  level3 = 0.01,
  absValue = -log(0.05, 10),
  adjusted = TRUE,
  txtsize = 1,
  font.family = "sans",
  treeHeight = 0.5,
  colors = NULL
)
}
\arguments{
\item{inFile}{inFile - results object from the DASVA analysis}

\item{goAnnotations}{parallel to goAnnotations from gomwuStats from RBGOA. Here, "database_bacteria_package_all.tab" if Bacteria, "database_fungi_package_all.tab" if Fungi}

\item{goDivision}{parallel to goAnnotations from gomwuStats from RBGOA. Here, "TR" = taxonomic Rank, don't change this}

\item{level1}{level1}

\item{level2}{level2}

\item{level3}{level3}

\item{absValue}{absValue}

\item{adjusted}{adjusted}

\item{txtsize}{txtsize}

\item{font.family}{font.family}

\item{treeHeight}{treeHeight}

\item{colors}{colors}
}
\value{
List for the statistical analysis for taxonomic rank
}
\description{
taxon Mann-Whitney U list for taxonomic analysis
}
\examples{
\dontrun{taxon_list <- taxon_mwu_list(input, ...)}
}
