% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{MLEGO}
\alias{MLEGO}
\title{General Odds (GO) Model.}
\usage{
MLEGO(
  init,
  times,
  status,
  n,
  basehaz,
  z,
  zt,
  method = "BFGS",
  hessian = TRUE,
  conf.int = 0.95,
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: initial points for optimisation}

\item{times}{: survival times}

\item{status}{: vital status (1 - dead, 0 - alive)}

\item{n}{: The number of the data set}

\item{basehaz}{: baseline hazard structure including baseline (New generalized log-logistic general  odds "NGLLGO" model,  generalized log-logisitic general odds "GLLGO" model,
modified log-logistic general odds "MLLGO" model,exponentiated Weibull general odds "EWGO" model,
power generalized weibull general  odds "PGWGO" model, generalized gamma general odds "GGGO" model,
modified kumaraswamy Weibull general odds "MKWGO" model, log-logistic general odds "LLGO" model,
tangent-log-logistic general odds "TLLGO" model, sine-log-logistic general odds "SLLGO" model,
cosine log-logistic general  odds "CLLGO" model,secant-log-logistic general odds "SCLLGO" model,
arcsine-log-logistic general odds "ASLLGO" model, arctangent-log-logistic general odds "ATLLGO" model,
Weibull general odds "WGO" model, gamma general odds "WGO" model, and log-normal general odds "ATLNGO" model.)}

\item{z}{: design matrix for odds-level effects (p x n), p >= 1}

\item{zt}{: design matrix for time-dependent effects (q x n), q >= 1}

\item{method}{:"optim" or a method from "nlminb".The methods supported are: BFGS (default), "L-BFGS", "Nelder-Mead", "SANN", "CG", and "Brent".}

\item{hessian}{:A function to return (as a matrix) the hessian for those methods that can use this information.}

\item{conf.int}{: confidence level}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the log-likelihood function (loglik)
}
\description{
A Tractable Parametric General Odds (GO) model's Log-likelihood, MLE and information criterion values.
Baseline hazards: NGLL,GLL,MLL,PGW, GG, EW, MKW, LL, TLL, SLL,CLL,SCLL,ATLL, and ASLL
}
\examples{

#Example #1
data(alloauto)
time<-alloauto$time
delta<-alloauto$delta
z<-alloauto$type
MLEGO(init = c(1.0,0.50,0.50,0.5,0.5),times = time,status = delta,n=nrow(z),
basehaz = "PGWGO",z = z,zt=z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #2
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
MLEGO(init = c(1.0,0.50,0.45,0.5),times = time,status = delta,n=nrow(z),
basehaz = "TLLGO",z = z,zt=z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

#Example #3
data("gastric")
time<-gastric$time
delta<-gastric$status
z<-gastric$trt
MLEGO(init = c(1.0,1.0,0.50,0.5,0.5),times = time,status = delta,n=nrow(z),
basehaz = "GLLGO",z = z,zt=z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)


}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
