% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ames.R
\name{make_ames}
\alias{make_ames}
\alias{make_ames_new}
\alias{make_ordinal_ames}
\title{Create a Processed Version of the Ames Housing Data}
\usage{
make_ames()

make_ames_new()

make_ordinal_ames()
}
\value{
A tibble with the data.
}
\description{
Create a Processed Version of the Ames Housing Data
}
\details{
For the processed version, the exact details can be found in
the code of \code{make_ames} but a summary of the differences between
these data sets and \code{ames_raw} is:
\itemize{
\item All factors are \emph{unordered}.
\item \code{PID} and \code{Order} are removed.
\item Spaces and special characters in column names where changed
to snake case. To be consistent, \code{SalePrice} was changed to
\code{Sale_Price}.
\item Many factor levels were changed to be more understandable
(e.g. \code{Split_or_Multilevel} instead of \code{080})
\item Many missing values were reset. For example, if the variable
\code{Bsmt_Qual} was missing, this implies that there is no basement
on the property. Instead of a missing value, the value of
\code{Bsmt_Qual} was changed to \code{No_Basement}. Similarly, numeric
data pertaining to basements were set to zero where appropriate
such as variables \code{Bsmt_Full_Bath} and \code{Total_Bsmt_SF}.
\item \code{Garage_Yr_Blt} contained many missing data and was removed.
\item Approximate longitude and latitude are included for the
properties. Also, note that there are 6 properties with
identical geotags. These are units within the same building.
For some properties, updated versions of the PID identifiers
were found and are replaced with new values.
}

\code{make_ordinal_ames} is the same as \code{make_ames} but many factor
variables were changed to class \code{ordered} (see below).

The documentation for \code{\link[=ames_raw]{ames_raw()}} contains descriptions of
the columns although, as noted above, the column names in
\code{\link[=ames_raw]{ames_raw()}} are slightly different from the processed
versions.

\code{make_ames_new()} creates a data set of new properties. These were populated
using less data sources than the original and lack a number of the condition
and quality. Both properties were unsold at the time of this writing.
}
\examples{
ames <- make_ames()
nrow(ames)
summary(ames$Sale_Price)

ames_ord <- make_ordinal_ames()
ord_vars <- vapply(ames_ord, is.ordered, logical(1))
names(ord_vars)[ord_vars]
}
