% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Air_methods.R
\name{rnormAR1}
\alias{rnormAR1}
\title{Generate normal samples (Autoregressive AR(1) correlation)}
\usage{
rnormAR1(n, p, rho = 0.5, means = 0, variances = 1)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of variables.}

\item{rho}{Autoregressive correlation coefficient.}

\item{means}{Numeric vector of feature means (length \eqn{1} or \eqn{p}).}

\item{variances}{Numeric vector of feature variances (length \eqn{1} or
\eqn{p}).}
}
\value{
A numeric \eqn{n \times p} matrix with the specified correlation,
means, and variances.
}
\description{
\code{rnormAR1} efficiently generates samples from a multivariate
normal distribution with AR(1)
correlation \eqn{cor(x_i, x_j) = \rho^{\lvert i-j \rvert}}.
}
\examples{
X1 <- rnormAR1(10, 5)
X2 <- rnormAR1(10, 5, rho = 0.3, means = 2, variances = 4)
X3 <- rnormAR1(10, 5, rho = 0.4, means = 1:5, variances = 3:7)
}
