% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_two_function.R
\name{test_two}
\alias{test_two}
\title{Analysis: Test for two samples}
\usage{
test_two(
  trat,
  resp,
  paired = FALSE,
  correct = TRUE,
  test = "t",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  theme = theme_classic(),
  ylab = "Response",
  xlab = "",
  var.equal = FALSE,
  pointsize = 2,
  yposition.p = NA,
  xposition.p = NA,
  fill = "white"
)
}
\arguments{
\item{trat}{Categorical vector with the two treatments}

\item{resp}{Numeric vector with the response}

\item{paired}{A logical indicating whether you want a paired t-test.}

\item{correct}{A logical indicating whether to apply continuity correction in the normal approximation for the p-value.}

\item{test}{Test used (t for test t or w for Wilcoxon test)}

\item{alternative}{A character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{conf.level}{Confidence level of the interval.}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{ylab}{Variable response name (this argument uses the \emph{parse} function)}

\item{xlab}{Treatments name (this argument uses the \emph{parse} function)}

\item{var.equal}{A logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{pointsize}{Point size}

\item{yposition.p}{Position p-value in y}

\item{xposition.p}{Position p-value in x}

\item{fill}{fill box}
}
\value{
Returns the test for two samples (paired or unpaired t test, paired or unpaired Wilcoxon test)
}
\description{
Test for two samples (paired and unpaired t test, paired and unpaired Wilcoxon test)
}
\details{
Alternative = "greater" is the alternative that x has a larger mean than y. For the one-sample case: that the mean is positive.

If paired is TRUE then both x and y must be specified and they must be the same length. Missing values are silently removed (in pairs if paired is TRUE). If var.equal is TRUE then the pooled estimate of the variance is used. By default, if var.equal is FALSE then the variance is estimated separately for both groups and the Welch modification to the degrees of freedom is used.

If the input data are effectively constant (compared to the larger of the two means) an error is generated.
}
\examples{
resp=rnorm(100,100,5)
trat=rep(c("A","B"),e=50)
test_two(trat,resp)
test_two(trat,resp,paired = TRUE)
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
