% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointcluster.R
\name{jointcluster}
\alias{jointcluster}
\title{Analysis: Method to evaluate similarity of experiments based on QMres}
\usage{
jointcluster(qmres, information = "matrix", method.cluster = "ward.D")
}
\arguments{
\item{qmres}{Vector containing mean squares of residuals or output from list DIC or DBC function}

\item{information}{Option to choose the return type. `matrix`, `bar` or `cluster`}

\item{method.cluster}{Grouping method}
}
\value{
Returns a residual mean square ratio matrix, bar graph with ratios sorted in ascending order, or cluster analysis.
}
\description{
This function presents a method to evaluate similarity of experiments based on a matrix of QMres of all against all. This is used as a measure of similarity and applied in clustering.
}
\examples{
qmres=c(0.344429, 0.300542, 0.124833, 0.04531, 0.039571, 0.011812, 0.00519)
jointcluster(qmres,information = "cluster")
jointcluster(qmres,information = "matrix")
jointcluster(qmres,information = "bar")

data(mirtilo)
m=lapply(unique(mirtilo$exp),function(x){
  m=with(mirtilo[mirtilo$exp==x,],DBC(trat,bloco,resp))})
jointcluster(m)
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
\keyword{Joint}
\keyword{analysis}
