% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dic_ad.R
\name{dic.ad}
\alias{dic.ad}
\title{Analysis: Completely randomized design with an additional treatment for quantitative factor}
\usage{
dic.ad(
  trat,
  response,
  responsead,
  grau = 1,
  norm = "sw",
  homog = "bt",
  alpha.f = 0.05,
  theme = theme_classic(),
  ylab = "response",
  xlab = "independent",
  family = "sans",
  posi = "top",
  pointsize = 4.5,
  linesize = 0.8,
  width.bar = NA,
  point = "mean_sd"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{response}{Numerical vector containing the response of the experiment.}

\item{responsead}{Numerical vector with additional treatment responses}

\item{grau}{Degree of polynomial in case of quantitative factor (\emph{default} is 1)}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{ylab}{Variable response name (this argument uses the \emph{parse} function)}

\item{xlab}{Treatments name (this argument uses the \emph{parse} function)}

\item{family}{Font family}

\item{posi}{Legend position}

\item{pointsize}{Point size}

\item{linesize}{line size (Trendline and Error Bar)}

\item{width.bar}{width of the error bars of a regression graph.}

\item{point}{Defines whether to plot mean ("mean"), mean with standard deviation ("mean_sd" - \emph{default}) or mean with standard error (\emph{default} - "mean_se"). For quali=FALSE or quali=TRUE.}
}
\value{
The table of analysis of variance, the test of normality of errors (Shapiro-Wilk ("sw"), Lilliefors ("li"), Anderson-Darling ("ad"), Cramer-von Mises ("cvm"), Pearson ("pearson") and Shapiro-Francia ("sf")), the test of homogeneity of variances (Bartlett ("bt") or Levene ("levene")), the test of independence of Durbin-Watson errors, adjustment of regression models up to grade 3 polynomial. The function also returns a standardized residual plot.
}
\description{
Statistical analysis of experiments conducted in a completely randomized with an additional treatment and balanced design with a factor considering the fixed model.
}
\note{
In some experiments, the researcher may study a quantitative factor, such as fertilizer doses, and present a control, such as a reference fertilizer, treated as a qualitative control. In these cases, there is a difference between considering only the residue in the unfolding of the polynomial, removing or not the qualitative treatment, or since a treatment is excluded from the analysis. In this approach, the residue used is also considering the qualitative treatment, a method similar to the factorial scheme with additional control.
}
\examples{
datadicad=data.frame(doses = c(rep(c(1:5),e=3)),
                     resp = c(3,4,3,5,5,6,7,7,8,4,4,5,2,2,3))
with(datadicad,dic.ad(doses, resp, rnorm(3,6,0.1),grau=2))
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DIC}
\keyword{additional}
\keyword{treatment}
