% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_function.R
\name{desc}
\alias{desc}
\title{Descriptive: Descriptive analysis}
\usage{
desc(trat, response, ylab = "Response", xlab = "Treatment", ylim = NA)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{response}{Numerical vector containing the response of the experiment.}

\item{ylab}{Variable response name (this argument uses the \emph{parse} function)}

\item{xlab}{x name (this argument uses the \emph{parse} function)}

\item{ylim}{y-axis scale}
}
\value{
The function returns exploratory measures of position and dispersion, such as mean, median, maximum, minimum, coefficient of variation, etc ...
}
\description{
Performs the descriptive analysis of an experiment with a factor of interest.
}
\examples{
library(AgroR)
data("pomegranate")
with(pomegranate, desc(trat,WL))
}
\seealso{
\link{desc2fat}, \link{tabledesc},\link{dispvar}
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Descriptive}
\keyword{Experimental}
