% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tube_eff.R
\name{tube_eff}
\alias{tube_eff}
\title{Tube efficiency}
\usage{
tube_eff(df, params, L_cm, angle_to_horiz, elnum)
}
\arguments{
\item{df}{is the particle data set (data frame) established with the
`particle_dist` function}

\item{params}{is the parameter data set for parameters that are not
particle size-dependent}

\item{L_cm}{tube length, cm}

\item{angle_to_horiz}{angle to horizontal in degrees}

\item{elnum}{element number to provide unique column names}
}
\value{
data frame containing original particle distribution with added
data for this element
}
\description{
Computation is consistent with the approach described in Hogue, Mark;
Thompson, Martha; Farfan, Eduardo; Hadlock, Dennis, (2014),
"Hand Calculations for Transport of Radioactive Aerosols through
Sampling Systems" Health Phys 106, 5, S78-S87,
<doi:10.1097/HP.0000000000000092>, with the exception that the diffusion
deposition mechanism is included.
}
\details{
In order to run this function, first produce a particle distribution
with the `particle_dist` function, then produce a parameter set with
the `set_params` function. Both of these results must be stored as
per examples described in the help set with each.
}
\examples{
# Example output is a sample of the full particle data set.

# laminar flow (Reynolds number < 2100)

df <- particle_dist() #  distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 20,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- tube_eff(df, params, L_cm = 100,
angle_to_horiz = 90, elnum = 2)
(df[sort(sample(1:1000, 10)), ])
# turbulent flow (Reynolds number > 4000)

df <- particle_dist() #  distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- tube_eff(df, params, L_cm = 100,
angle_to_horiz = 90, elnum = 2)
(df[sort(sample(1:1000, 10)), ])

# midrange flow (Reynolds number > 2100 and < 4000)

df <- particle_dist() #  distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 60,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- tube_eff(df, params, L_cm = 100,
angle_to_horiz = 90, elnum = 2)
(df[sort(sample(1:1000, 10)), ])

}
