% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apf_plot.R
\name{apf_plot}
\alias{apf_plot}
\title{Generate smooth graphs for the APF and FDR estimates}
\usage{
apf_plot(APF_lst, tab = TRUE, APF_inf = 0.5, FDR_sup = 0.05)
}
\arguments{
\item{APF_lst}{The output from the \code{apf_fdr} function.}

\item{tab}{If \code{TRUE}, a table with relevant values of APF, FDR,
tau and gamma is printed.}

\item{APF_inf}{Sets the minimum value of APF to appear in the table
when \code{tab = TRUE}.}

\item{FDR_sup}{Sets the maximum value of Bayes FDR to appear in the
table when \code{tab = TRUE}.}
}
\value{
Smooth graphs for APF vs Gamma (left), FDR vs Gamma (centre)
and APF vs FDR (right). Regions where FDR \eqn{\le} \code{FDR_sup} and
APF \eqn{\ge} \code{APF_inf} (if presents) are highlighted in yellow
and printed in a table (if \code{tab = TRUE}) together with the relative
values of \emph{gamma} and \emph{tau}.
}
\description{
\code{apf_plot} returns a graph with Average Power Function (APF),
Bayes False Discovery Rate (FDR) and APF vs. FDR. In addition, when
\code{tab = TRUE}, a table containing APF, FDR, tau and gamma values
 for a selected subset of APF and FDR is printed.
}
\examples{
data("Ex2")
apf_plot(Ex2)
# Ex2 is an example of output obtained
# from the apf_fdr() function.

}
\references{
Quatto, P, Margaritella, N, et al. Brain networks
construction using Bayes FDR and average power function. \emph{Stat Methods Med Res}.
Published online May 14th, 2019; DOI:10.1177/0962280219844288.
}
