% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.ratio.R
\name{lik.ratio}
\alias{lik.ratio}
\title{Perform Likelihood ratio test}
\usage{
lik.ratio(
  x,
  y,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.exact = TRUE,
  do.asymp = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{x}{Factor of same length as y}

\item{y}{Factor of same length as x}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{lik.ratio()} performs the Likelihood ratio test and is used in chapters 12 and 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 12.2 from "Applied Nonparametric Statistical Methods" (5th edition)
lik.ratio(ch12$infection.site, ch12$district, do.exact = FALSE, do.asymp = TRUE)

# Example 13.12 from "Applied Nonparametric Statistical Methods" (5th edition)
chemo.side.effect.3 <- ch13$chemo.side.effect
levels(chemo.side.effect.3) <- list("Side-effect" = c("Hair loss",
  "Visual impairment", "Hair loss & Visual impairment"), "None" = "None")
lik.ratio(ch13$chemo.drug, chemo.side.effect.3, seed = 1)

}
