% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMIS_outputs.R
\name{plot_mixture_components}
\alias{plot_mixture_components}
\title{Wrapper function for \code{\link[mclust]{plot.Mclust}()}}
\usage{
plot_mixture_components(
  x,
  what = "uncertainty",
  iteration = NULL,
  datapoints = "proposed",
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{The output from the function \code{\link{amis}()}.}

\item{what}{A string specifying the type of plot requested:
\describe{
\item{\code{"uncertainty"}}{A plot of classification uncertainty (default)}
\item{\code{"density"}}{A plot of estimated density}
\item{\code{"BIC"}}{A plot showing BIC values used to choose the number of components}
}}

\item{iteration}{Integer indicating which iteration the plot should be about.
If \code{NULL} (default), the plot will be for the final iteration.
See more details in \code{\link[mclust]{plot.Mclust}()}.}

\item{datapoints}{A string specifying what the datapoints should represent in the
plot of classification uncertainty:
\describe{
\item{\code{"proposed"}}{datapoints will represent the samples simulated from the mixture.
The colours indicate which mixture components the samples were simulated from.}
\item{\code{"fitted"}}{datapoints will show the samples that the mixture model was fitted to,
i.e. weighted samples from the previous iteration.
The colour of a datapoint indicates the most likely mixture component the sample belongs to.}
}}

\item{main}{Title of the plot. If \code{NULL}, the default title will be displayed. Set to \code{NA} for omitting title.}

\item{xlim}{The x limits of the plots. Default to \code{NULL}}

\item{ylim}{The y limits of the plots. Default to \code{NULL}.}

\item{...}{Other arguments to match the \code{\link[mclust]{plot.Mclust}()} function.}
}
\value{
A plot for model-based clustering results.
}
\description{
Wrapper function for \code{\link[mclust]{plot.Mclust}()}
}
\details{
For illustrative examples, see \code{\link{amis}()}.
}
