% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHReg1.R
\name{AEHMLE}
\alias{AEHMLE}
\title{Relative Survival AH model.}
\format{
By default the function calculates the following values:
\itemize{
  \item AIC:  Akaike Information Criterion;
   \item CAIC: Consistent Akaikes Information Criterion;
    \item BIC:  Bayesian Information Criterion;
     \item BCAIC:  Bozdogan’s Consistent Akaike Information Criterion;
     \item HQIC:  Hannan-Quinn information criterion;
     \item par:  maximum likelihood estimates;
     \item Value:  value of the likelihood function;
    \item Convergence:  0 indicates successful completion and 1 indicates that the iteration limit maxit.
 }
}
\usage{
AEHMLE(
  init,
  time,
  delta,
  n,
  basehaz,
  z,
  hp.obs,
  method = "Nelder-Mead",
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: initial points for optimisation}

\item{time}{: survival times}

\item{delta}{: vital indicator (0-alive,1 - dead)}

\item{n}{: The number of the observations of the data set}

\item{basehaz}{: {baseline hazard structure including baseline
(NGLLAEH,GLLAEH,EWAEH,KWAEH,MLLAEH,
PGWAEH,GGAEH,MKWAEH,LLAEH,WAEH,GAEH,
LNAEH,BXIIAEEH)}}

\item{z}{: design matrix for covariates (p x n), p >= 1}

\item{hp.obs}{: population hazards (for uncensored individuals)}

\item{method}{:"nlminb" or a method from "optim"}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the information criterion including (AIC, BIC, CAIC, BCAIC, and HQIC).
}
\description{
The flexible parametric accelerated excess hazards (AEH) model's maximum likelihood estimation, log-likelihood, and information criterion.
Baseline hazards:NGLL, GLL, KW,EW, MLL, PGW, GG, MKW, Log-logistic, Weibull,  Log-normal, Burr-XII, and Gamma
}
\examples{
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
AEHMLE(init = c(1.0,0.5,1.0,0.5),time = time,delta = delta,n=nrow(z),
basehaz = "GLLAEH",z = z,hp.obs=0.6,method = "Nelder-Mead",
maxit = 1000)

}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Mutua Kilai, \email{abdisalam.hassan@amoud.edu.so}
}
