% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broken_stick.R
\name{broken_stick}
\alias{broken_stick}
\title{Random generation of datasets using the dirichlet broken stick method}
\usage{
broken_stick(
  n_obs = 1000,
  n_groups = 10,
  ess_fraction = 1,
  tot_n = 100,
  p = NULL
)
}
\arguments{
\item{n_obs}{Number of observations (rows of data matrix to simulate). Defaults to 10}

\item{n_groups}{Number of categories for each observation (columns of data matrix). Defaults to 10}

\item{ess_fraction}{The effective sample size fraction, defaults to 1}

\item{tot_n}{The total sample size to simulate for each observation. This is approximate and the actual
simulated sample size will be slightly smaller. Defaults to 100}

\item{p}{The stock proportions to simulate from, as a vector. Optional, and when not included,
random draws from the dirichlet are used}
}
\value{
A 2-element list, whose 1st element \code{X_obs} is the simulated dataset, and whose
2nd element is the underlying vector of proportions \code{p} used to generate the data
}
\description{
Random generation of datasets using the dirichlet broken stick method
}
\examples{
\donttest{
y <- broken_stick(n_obs = 3, n_groups = 5, tot_n = 100)

# add custom proportions
y <- broken_stick(
  n_obs = 3, n_groups = 5, tot_n = 100,
  p = c(0.1, 0.2, 0.3, 0.2, 0.2)
)
}
}
