% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlib.R
\name{publicEval}
\alias{publicEval}
\title{Evaluate Expression with Public and Private Environments}
\usage{
publicEval(expr, parentEnv = parent.frame(), name = NULL)
}
\arguments{
\item{expr}{An expression to evaluate within the constructed environment hierarchy.}

\item{parentEnv}{The parent environment for the new 'public' environment. Default is the parent frame.}

\item{name}{Optional name attribute to set for the public environment.}
}
\value{
Returns an invisible reference to the public environment.
}
\description{
\code{publicEval} creates an environment hierarchy consisting of
public, self, and private environments. The expression \code{expr} is
evaluated within these nested environments, allowing for controlled
variable scope and encapsulation.
}
\section{Environments}{

\itemize{
\item Public: Variables in this environment are externally accessible.
\item Self: Inherits from Public and also contains Private and Public as children.
\item Private: Variables are encapsulated and are not externally accessible.
}
}

\examples{
publicEnv <- publicEval({
  private$hidden_var <- "I am hidden"
  public_var <- "I am public"
}, parentEnv = parent.frame(), name = "MyEnvironment")

print(exists("public_var", envir = publicEnv))  # Should return TRUE
print(exists("hidden_var", envir = publicEnv))  # Should return FALSE

}
\keyword{internal}
