% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.order.mc}
\alias{Zeta.order.mc}
\title{Zeta diversity for a specific number of assemblages or sites using Monte Carlo sampling}
\usage{
Zeta.order.mc(data.spec, xy = NULL, order = 1, sam = 1000,
  sd.correct = TRUE, sd.correct.adapt = FALSE, rescale = FALSE,
  normalize = FALSE, NON = FALSE, FPO = NULL, DIR = FALSE,
  empty.row = "empty", silent = TRUE)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{xy}{Site coordinates. This is only used if \code{NON} = TRUE or \code{DIR} = TRUE.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta diversity is computed.}

\item{sd.correct}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) or not (using the number of site combinations as the denominator).}

\item{sd.correct.adapt}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) if \code{sam} is higher than the number of possible combinations, or not (using the number of site combinations as the denominator) if \code{sam} is lower than the number of possible combinations. If \code{sd.correct.adapt == TRUE}, it takes precedence over \code{sd.correct}.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the total number of species for this specific sample (\code{normalize = "Jaccard"}), by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}), or by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}). Default value is \code{FALSE}, indicating that no normalization is performed.}

\item{NON}{Boolean value (TRUE or FALSE) indicating if the number of species in common should only be counted for the nearest neighbours.}

\item{FPO}{A vector with the coordinates of the fixed point origin from which the zeta diversity will be computed (overrides NON). In that case, \eqn{\zeta_1} is the number of species in the closest site to the FPO, \eqn{\zeta_2} is the number of species shared by the 2 closest sites, etc.}

\item{DIR}{Boolean value (TRUE or FALSE) indicating if zeta diversity must be computed using a directed nearest neighbour scheme in the direction away from the FPO, starting from any site.}

\item{empty.row}{Determines how to handle empty rows, i.e. sites with no species. Such sites can cause underestimations of zeta diversity, and computation errors for the normalized version of zeta due to divisions by 0. Options are "\code{empty}" to let the data untreated, "\code{remove}" to remove the empty rows, 0 to set the normalized zeta to 0 when zeta is divided by 0 during normalization (sites share no species, so are completely dissimilar), and 1 to set the normalized zeta to 1 when zeta is divided by 0 during normalization (i.e. sites are perfectly similar).}

\item{silent}{Boolean value (TRUE or FALSE) indicating if messages must be printed.}
}
\value{
\code{Zeta.order.mc}  returns a list containing the following components:

\item{zeta.order}{The number of assemblages or sites for which the zeta diversity was computed.}

\item{zeta.val}{The zeta diversity values.}

\item{zeta.val.sd}{The standard deviation of zeta diversity.}
}
\description{
Computes zeta diversity, the number of species shared by multiple assemblages, for a specific order (number of assemblages or sites).
}
\details{
If the number of combinations of sites is lower than the value of the parameter \code{sam}, all the combinations are used and an exact solution is computed. In that case, using the number of site combinations as the denominator may be appropriate to compute the standard deviation, if all sites were sampled and the zeta values. This can be adjusted with parameters \code{sd.correct} and \code{sd.correct.adapt}.

\code{Zeta.order.mc} is faster than \code{\link{Zeta.order.ex}} to compute the exact value of zeta diversity when the number of species is higher than \eqn{C^N_{i}}, where \emph{N} is the total number of sites and \emph{i} is the order of zeta.

\code{Zeta.order.mc} enables accomodating richness heterogeneity by setting \code{normalize = "Jaccard"}, \code{normalize = "Sorensen"} or \code{normalize = "Simpson"}. This cannot be performed by \cr \code{\link{Zeta.order.ex}}.
}
\examples{

utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[,1:2]
data.spec.bird <- bird.spec.coarse[,3:193]

zeta.bird <- Zeta.order.mc(data.spec.bird, order = 3, sam=100)
zeta.bird

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

zeta.marion <- Zeta.order.mc(data.spec.marion, xy.marion, order = 3, sam = 100,
   NON = TRUE)
zeta.marion

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}
}
