% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{glm.fit.cons}
\alias{glm.fit.cons}
\title{Generalized Linear Models fitting method with negative coefficients constraint}
\usage{
glm.fit.cons(x, y, weights = rep(1, nobs), cons = -1, cons.inter = 1,
  start = NULL, etastart = NULL, mustart = NULL, offset = rep(0, nobs),
  family = stats::gaussian(), control = list(), intercept = TRUE)
}
\arguments{
\item{x}{as for \code{\link{glm.fit}}}

\item{y}{as for \code{\link{glm.fit}}}

\item{weights}{as for \code{\link{glm.fit}}}

\item{cons}{type of constraint. Default is -1 for negative coefficients on the predictors. The other option is 1 for positive coefficients on the predictors.}

\item{cons.inter}{type of constraint for the intercept. Default is 1 for positive intercept, suitable for Gaussian family. The other option is -1 for negative intercept, suitable for binomial family.}

\item{start}{as for \code{\link{glm.fit}}}

\item{etastart}{as for \code{\link{glm.fit}}}

\item{mustart}{as for \code{\link{glm.fit}}}

\item{offset}{as for \code{\link{glm.fit}}}

\item{family}{as for \code{\link{glm.fit}}}

\item{control}{as for \code{\link{glm.fit}}}

\item{intercept}{as for \code{\link{glm.fit}}}
}
\value{
The value returned by \code{glm.fit.cons} has exactly the same structure as the value returned by \code{glm.fit} and \code{glm.fit2}.
}
\description{
\code{glm.fit.cons} is an adaptation of function \code{glm.fit2} from package \{glm2\} in which the least squares estimation is replaced by a non-positive regression using function \code{nnnpls} from package \{nnls\}.
}
\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm.cons(counts ~ outcome + treatment, family = poisson())
glm.D93.ngl <- glm.cons(counts ~ outcome + treatment, family = poisson(),method="glm.fit.cons")
summary(glm.D93)
summary(glm.D93.ngl)
}
\references{
Marschner, I.C. (2011) glm2: Fitting generalized linear models with convergence problems. \emph{The R Journal}, 3(2), 12-15.
}
\seealso{
\code{\link{glm.fit}}, \code{\link{glm.fit2}}
}

