% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zen4R_downloader.R
\name{download_zenodo}
\alias{download_zenodo}
\title{download_zenodo}
\usage{
download_zenodo(
  doi,
  path = ".",
  files = list(),
  logger = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{doi}{a Zenodo DOI or concept DOI}

\item{path}{the target directory where to download files}

\item{files}{subset of filenames to restrain to download. If ignored, all files will be downloaded.}

\item{logger}{a logger to print Zenodo API-related messages. The logger can be either NULL, 
"INFO" (with minimum logs), or "DEBUG" (for complete curl http calls logs)}

\item{quiet}{Logical (\code{FALSE} by default).
Do you want to suppress informative messages (not warnings)?}

\item{...}{any other arguments for parallel downloading (more information at
\link{ZenodoRecord}, \code{downloadFiles()} documentation)}
}
\description{
\code{download_zenodo} allows to download archives attached to a Zenodo
record, identified by its DOI or concept DOI.
}
\examples{
\dontrun{
 #simple download (sequential)   
 download_zenodo("10.5281/zenodo.2547036")
 
 library(parallel)
 #download files as parallel using a cluster approach (for both Unix/Win systems)
 download_zenodo("10.5281/zenodo.2547036", 
   parallel = TRUE, parallel_handler = parLapply, cl = makeCluster(2))
 
 #download files as parallel using mclapply (for Unix systems)
 download_zenodo("10.5281/zenodo.2547036",
   parallel = TRUE, parallel_handler = mclapply, mc.cores = 2)
}
                
}
