% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tickets_comments.R
\name{get_tickets_comments}
\alias{get_tickets_comments}
\title{Get tickets comments/replies}
\usage{
get_tickets_comments(
  email_id,
  token,
  subdomain,
  ticket_id,
  add_cols = NULL,
  metadata = FALSE
)
}
\arguments{
\item{email_id}{Zendesk Email ID (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}

\item{ticket_id}{The ticket ID number. A numeric value.}

\item{add_cols}{Vector of column names to select in addition to the default.}

\item{metadata}{Logical value (TRUE or FALSE). If TRUE, metadata columns will
be included. This is set to FALSE by default.}
}
\value{
a Data Frame containing all comments/replies for a single ticket.
}
\description{
This function takes your email ID, authentication token, sub-domain,
and specific ticket ID to fetch all comments/replies to this wanted ticket.
}
\details{
By default only these columns are returned: "id", "type", "author_id",
"body", "created_at", "have_attachments". You can add other variables using
the `add_cols` parameter. The variables that can be inserted are described in
the Zendesk API documentation: https://developer.zendesk.com/api-reference/
ticketing/tickets/ticket_comments/.

The meaning of the default columns included are described in the previous
link, except "have-attachments" which is a boolean field that will be "Yes"
if the comment has an attachment or "No" if it does not. The attachment
itself cannot be returned.

If you request the `metadata` sensitive data (location, lat, long,
IP address, etc.) will be included. This data should be handled with care and
only stored and used per your organization's policies and applicable
privacy regulations.
}
\examples{
\dontrun{
## Extracting comments with default columns and without sensitive data
comments_ticket_id <- get_tickets_comments(email_id, token, subdomain,
ticket_id, add_cols = NULL, metadata = FALSE)

## Extracting comments with additional columns and sensitive data
comments_ticket_id <- get_tickets_comments(email_id, token, subdomain,
ticket_id, add_cols = c("html_body", "attachments"), metadata = TRUE)
}
}
\references{
\url{https://developer.zendesk.com/api-reference/ticketing/
tickets/ticket_comments/}
}
