% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yonder.R
\docType{package}
\name{yonder-package}
\alias{yonder}
\alias{yonder-package}
\title{An opinionated shiny framework}
\description{
Yonder is a set of tools for flexible and creative shiny application
construction and design.
}
\section{Inputs}{


Yonder provides many familiar inputs like \code{\link[=selectInput]{selectInput()}} or \code{\link[=radioInput]{radioInput()}}.
There are also new inputs like \code{\link[=groupTextInput]{groupTextInput()}} or \code{\link[=formInput]{formInput()}}.

\strong{Changes to be mindful of}
\itemize{
\item Input functions have an \code{id} argument instead of \code{inputId}.
\item Input functions do not include a \code{label} argument for the purpose of adding
a label above the input. Button and menu inputs do include a \code{label}
argument, but these arguments refer to button labels. If you would like to
add a label above an input please use \code{\link[=formGroup]{formGroup()}}.
}

\strong{Familiar variants}

Looking for ... ?
\itemize{
\item \code{actionButton()} or \code{actionLink()} use \code{\link[=buttonInput]{buttonInput()}} or \code{\link[=linkInput]{linkInput()}}
\item \code{radioButtons()} use \code{\link[=radioInput]{radioInput()}}
\item \code{checkboxGroupInput()} use \code{\link[=checkbarInput]{checkbarInput()}} or \code{\link[=checkboxInput]{checkboxInput()}}
\item \code{numericInput()} use \code{\link[=numberInput]{numberInput()}}
\item \code{selectizeInput()} use \code{\link[=selectInput]{selectInput()}} or \code{\link[=chipInput]{chipInput()}}
\item \code{submitButton()} use \code{\link[=formInput]{formInput()}} and \code{\link[=formSubmit]{formSubmit()}}
}
}

\section{Layout and content}{


Included are a handful of utilities for building applications suited for
devices and screens of varying sizes. For real control over spacing elements
be sure to check out \code{\link[=flex]{flex()}}, which gives you the power of flexbox layout.

\strong{Familiar variants}

Looking for ... ?
\itemize{
\item \code{fluidRow()} or \code{fixedRow()} use \code{\link[=columns]{columns()}}
\item \code{fixedPage()}, \code{fluidPage()}, or \code{sidebarLayout()} use \code{\link[=container]{container()}},
\code{\link[=columns]{columns()}}, and \code{\link[=column]{column()}}
\item \code{navbarPage()} use \code{\link[=navbar]{navbar()}}
\item \code{tabPanel()} use \code{\link[=navContent]{navContent()}} and \code{\link[=navPane]{navPane()}}
\item \code{modalDialog()} use \code{\link[=modal]{modal()}}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://nteetor.github.io/yonder}
  \item Report bugs at \url{https://github.com/nteetor/yonder/issues}
}

}
\author{
\strong{Maintainer}: Nathan Teetor \email{nathanteetor@gmail.com}

Other contributors:
\itemize{
  \item  The Bootstrap Authors (Bootstrap library) [copyright holder]
  \item  Twitter, Inc (Bootstrap library) [copyright holder]
  \item  JS Foundation (jQuery library) [copyright holder]
  \item Federico Zivolo (popper.js library) [contributor, copyright holder]
  \item Johann Servoire (bs-custom-file-input library) [contributor, copyright holder]
}

}
