% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.R
\name{flex}
\alias{flex}
\title{Flex layout}
\usage{
flex(tag, direction = NULL, justify = NULL, align = NULL,
  wrap = NULL, reverse = NULL)
}
\arguments{
\item{tag}{A tag element.}

\item{direction}{A \link{responsive} argument. One of \code{"row"} or \code{"column"}
specifying the placement of flex items, defaults to \code{NULL}. If \code{"row"}
items are placed vertically, if \code{"column"} items are placed horizontally.
Browsers place items vertically by default.}

\item{justify}{A \link{responsive} argument. One of \code{"start"}, \code{"end"},
\code{"center"}, \code{"between"}, or \code{"around"} specifying how items are
horizontally aligned, defaults to \code{NULL}. See the \strong{justify} section below
for more on how the different values affect horizontal spacing.}

\item{align}{A \link{responsive} argument. One of \code{"start"}, \code{"end"}, \code{"center"},
\code{"baseline"}, or \code{"stretch"} specifying how items are vertically aligned,
defaults to \code{NULL}. See the \strong{align} section below for more on how the
different values affect vertical spacing.}

\item{wrap}{A \link{responsive} argument. One of \code{TRUE} or \code{FALSE} specifying
whether to wrap flex items inside the flex containter, \code{tag}, defaults
to \code{NULL}. If \code{TRUE} items wrap inside the container, if \code{FALSE} items will
not wrap. See the \strong{wrap} section below for more.}

\item{reverse}{A \link{responsive} argument. One of \code{TRUE} or \code{FALSE} specifying
if flex items are placed in reverse order, defaults to \code{NULL}. If \code{TRUE}
items are placed from right to left when \code{direction} is \code{"row"} or bottom
to top when \code{direction} is \code{"column"}.}
}
\description{
Use \code{flex()} to control how a flex container tag element places its flex
items or child tag elements. For more on turning a tag element into a flex
container see \code{\link[=display]{display()}}. By default tag elements within a flex container
are treated as flex items.
}
\examples{

### Different `direction`s

# Many of `flex()`'s arguments are viewport responsive and below we will see
# how useful this can be. On small screens the flex items are placed
# vertically and can occupy the full width of the mobile device. On medium
# or larger screens the items are placed horizontally once again.

div(
  div("A flex item") \%>\%
    padding(3) \%>\%
    border(),
  div("A flex item") \%>\%
    padding(3) \%>\%
    border(),
  div("A flex item") \%>\%
    padding(3) \%>\%
    border()
) \%>\%
  display("flex") \%>\%
  flex(
    direction = list(xs = "column", md = "row")  # <-
  ) \%>\%
  background("grey") \%>\%
  border()

# *Resize the browser for this example.*

# You can keep items as a column by specifying only `"column"`.

div(
  div("A flex item") \%>\%
    padding(3) \%>\%
    border(),
  div("A flex item") \%>\%
    padding(3) \%>\%
    border(),
  div("A flex item") \%>\%
     padding(3) \%>\%
     border()
) \%>\%
  display("flex") \%>\%
  flex(direction = "column")  # <-

### Spacing items with `justify`

# Below is a series of examples showing how to change the horizontal
# alignment of your flex items. Let's start by pushing items to the
# beginning of their parent container.

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(justify = "start")  # <-

# We can also push items to the **end**.

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(justify = "end")  # <-

# Without using a table layout we can **center** items.

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(justify = "center")  # <-

# You can also put space **between** items

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(justify = "between")  # <-

# ... or put space **around** items.

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(justify = "around")  # <-

# *The "between" and "around" values come from the original CSS values
# "space-between" and "space-around".*

### Wrap onto new lines

# Using flexbox we can also control how items wrap onto new lines.

div(
  replicate(
    div("A flex item") \%>\%
      padding(3) \%>\%
      border(),
    n = 5,
    simplify = FALSE
  )
) \%>\%
  display("flex") \%>\%
  flex(wrap = TRUE)

}
\seealso{
Other layout functions: \code{\link{column}},
  \code{\link{fieldset}}, \code{\link{navbar}},
  \code{\link{responsive}}
}
\concept{layout functions}
