% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_rsconnect.R
\name{yml_rsconnect_email}
\alias{yml_rsconnect_email}
\alias{yml_output_metadata}
\title{Set YAML for Scheduled Emails in RStudio Connect}
\usage{
yml_rsconnect_email(
  .yml,
  rsc_email_subject = yml_blank(),
  rsc_email_body_html = yml_blank(),
  rsc_email_body_text = yml_blank(),
  rsc_email_images = yml_blank(),
  rsc_output_files = yml_blank(),
  rsc_email_attachments = yml_blank(),
  rsc_email_suppress_scheduled = yml_blank(),
  rsc_email_suppress_report_attachment = yml_blank(),
  resource_files = yml_blank(),
  ...
)

yml_output_metadata(.yml, ...)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{rsc_email_subject}{The subject of the email. A report without an
\code{rsc_email_subject} entry uses its published document name.}

\item{rsc_email_body_html, rsc_email_body_text}{The body of the email, either
in plain text or HTML. A report with neither entry uses an automatically
generated, plain-text body with a link to the report’s URL.}

\item{rsc_email_images}{Images to embed in the email. The embedded image must
have a Content ID that is used in the body of the HTML and when providing
the image to \code{rsc_email_images}, and the image itself must be
base64-encoded, e.g. with the base64enc package.}

\item{rsc_output_files}{A vector of file names that should be available after
the report has rendered. If you list a file that does not exist after
rendering your report, Connect will log a message but continue trying to
processing the other files listed. If the output files are not generated
during the rendering of your report, then you will also need to list them
in \code{resource_files} when you upload your report to Connect.}

\item{rsc_email_attachments}{A vector of file names that should be attached
to the email.}

\item{rsc_email_suppress_scheduled}{Logical. Should the email schedule be
suppressed? Default is \code{FALSE}.}

\item{rsc_email_suppress_report_attachment}{Logical. Should the rendered
document be included as an attachment? Default is \code{TRUE}.}

\item{resource_files}{A file or files to host on RStudio Connect that is
\emph{not} generated by your report, e.g. an existing file.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a \code{yml} object
}
\description{
RStudio Connect allows you to schedule emails to send using R Markdown. It
uses a special type of YAML using the top-level field \code{rmd_output_metadata}
that tells RStudio Connect about the email output. Several \verb{rsc_*} fields
exist to specify different components of the email, which can be set in the
YAML header or programmatically using \code{rmarkdown::output_metadata()}. See the
\href{https://docs.rstudio.com/connect/1.7.2/user/r-markdown.html}{RStudio Connect documentation}
for more. \code{yml_output_metadata()} allows you to add any type of content to
the \code{rmd_output_metadata} field.
}
\examples{

yml() \%>\%
  yml_rsconnect_email(
    rsc_email_subject = "Quarterly report",
    rsc_output_files = "data.csv",
    rsc_email_attachments = c("attachment_1.csv", "attachment_2.csv")
  )
}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
