% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-f_meas.R
\name{f_meas}
\alias{f_meas}
\alias{f_meas.data.frame}
\alias{f_meas_vec}
\title{F Measure}
\usage{
f_meas(data, ...)

\method{f_meas}{data.frame}(data, truth, estimate, beta = 1,
  estimator = NULL, na_rm = TRUE, ...)

f_meas_vec(truth, estimate, beta = 1, estimator = NULL, na_rm = TRUE,
  ...)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the \code{truth} and \code{estimate}
columns, or a \code{table}/\code{matrix} where the true class results should be
in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \code{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \code{_vec()} functions, a \code{factor} vector.}

\item{beta}{A numeric value used to weight precision and
recall. A value of 1 is traditionally used and corresponds to
the harmonic mean of the two values but other values weight
recall beta times more important than precision.}

\item{estimator}{One of: \code{"binary"}, \code{"macro"}, \code{"macro_weighted"},
or \code{"micro"} to specify the type of averaging to be done. \code{"binary"} is
only relevant for the two class case. The other three are general methods for
calculating multiclass metrics. The default will automatically choose \code{"binary"}
or \code{"macro"} based on \code{estimate}.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{f_meas_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
These functions calculate the \code{\link[=f_meas]{f_meas()}} of a measurement system for
finding relevant documents compared to reference results
(the truth regarding relevance). Highly related functions are \code{\link[=recall]{recall()}}
and \code{\link[=precision]{precision()}}.
}
\details{
The measure "F" is a combination of precision and recall (see below).
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the \emph{last} level of the factor is considered the
level of interest by running: \code{options(yardstick.event_first = FALSE)}.
For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\section{Multiclass}{


Macro, micro, and macro-weighted averaging is available for this metric.
The default is to select macro averaging if a \code{truth} factor with more
than 2 levels is provided. Otherwise, a standard binary calculation is done.
See \code{vignette("multiclass", "yardstick")} for more information.
}

\section{Implementation}{


Suppose a 2x2 table with notation:

\tabular{rcc}{ \tab Reference \tab \cr Predicted \tab Relevant \tab
Irrelevant \cr Relevant \tab A \tab B \cr Irrelevant \tab C \tab D \cr }

The formulas used here are:

\deqn{recall = A/(A+C)}
\deqn{precision = A/(A+B)}
\deqn{F_meas_\beta = (1+\beta^2) * precision * recall/((\beta^2 * precision)+recall)}

See the references for discussions of the statistics.
}

\examples{
# Two class
data("two_class_example")
f_meas(two_class_example, truth, predicted)

# Multiclass
library(dplyr)
data(hpc_cv)

hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  f_meas(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  f_meas(obs, pred)

# Weighted macro averaging
hpc_cv \%>\%
  group_by(Resample) \%>\%
  f_meas(obs, pred, estimator = "macro_weighted")

# Vector version
f_meas_vec(two_class_example$truth, two_class_example$predicted)

# Making Class2 the "relevant" level
options(yardstick.event_first = FALSE)
f_meas_vec(two_class_example$truth, two_class_example$predicted)
options(yardstick.event_first = TRUE)

}
\references{
Buckland, M., & Gey, F. (1994). The relationship
between Recall and Precision. \emph{Journal of the American Society
for Information Science}, 45(1), 12-19.

Powers, D. (2007). Evaluation: From Precision, Recall and F
Factor to ROC, Informedness, Markedness and Correlation.
Technical Report SIE-07-001, Flinders University
}
\seealso{
Other class metrics: \code{\link{accuracy}},
  \code{\link{bal_accuracy}},
  \code{\link{detection_prevalence}},
  \code{\link{j_index}}, \code{\link{kap}},
  \code{\link{mcc}}, \code{\link{npv}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{recall}},
  \code{\link{sens}}, \code{\link{spec}}

Other relevance metrics: \code{\link{precision}},
  \code{\link{recall}}
}
\author{
Max Kuhn
}
\concept{class metrics}
\concept{relevance metrics}
