% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_yamlet.R
\name{io_yamlet.data.frame}
\alias{io_yamlet.data.frame}
\title{Export Data Frame Attributes as Yamlet}
\usage{
\method{io_yamlet}{data.frame}(
  x,
  con = stdout(),
  eol = "\\n",
  useBytes = FALSE,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  fileEncoding = getOption("encoding"),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{con}{passed to \code{\link{writeLines}}}

\item{eol}{end-of-line; passed to \code{\link{writeLines}} as \code{sep}}

\item{useBytes}{passed to \code{\link{writeLines}}}

\item{default_keys}{character: default keys for the first n anonymous members of each element}

\item{fileEncoding}{if \code{con} is character, passed to \code{\link{file}} as \code{encoding}}

\item{...}{passed to \code{\link{as_yamlet}}}
}
\value{
invisible description of con: i.e., a file path
}
\description{
Writes data.frame attributes as yamlet.
The data.frame method for \code{\link{io_yamlet}}.
Similar to \code{\link{write_yamlet}}, but returns (description of) \code{con}.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
out <- file.path(tempdir(), 'out.yamlet')
io_yamlet(x, out)
io_yamlet(out)

}
\seealso{
Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{enscript.default}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}

Other io: 
\code{\link{io_csv}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
