% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionalize.R
\name{conditionalize.data.frame}
\alias{conditionalize.data.frame}
\title{Conditionalize Attributes of Data Frame}
\usage{
\method{conditionalize}{data.frame}(x, column, attribute, test, value, ...)
}
\arguments{
\item{x}{data.frame}

\item{column}{unquoted name of column to conditionalize}

\item{attribute}{unquoted name of attribute to create for column}

\item{test}{unquoted name of column to test}

\item{value}{unquoted name of column supplying attribute value}

\item{...}{ignored arguments}
}
\value{
class 'decorated' 'data.frame'
}
\description{
Conditionalizes attributes of data.frame.
Creates a conditional \code{attribute} definition
for \code{column} by mapping \code{value} to
\code{test}. Only considers records where
both \code{test} and \code{value} are defined,
and gives an error if there is not one-to-one mapping.
Can be used with write methods as an alternative
to hand-coding conditional metadata.
}
\details{
If the test column is character, individual
elements should not contain both single and
double quotes. For the conditional expressions,
these values will be single-quoted by default,
or double-quoted if they contain single quotes.
}
\examples{
library(magrittr)
library(dplyr)
library(csv)
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- as.csv(file)
head(x,3)

# suppose we have an event label stored as a column:

x \%<>\% mutate(evid = ifelse(
  event == 'dose',
  'dose of drug administered',
  'serum phenobarbital concentration'
 )
)

# We can define a conditional label for 'value'
# by mapping evid to event:

x \%<>\% conditionalize(value, label, event, evid)

x \%>\% as_yamlet
x \%>\% write_yamlet

}
\seealso{
Other interface: 
\code{\link{as_classified.factor}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{ggplot.decorated}()},
\code{\link{ggready.data.frame}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.data.frame}()},
\code{\link{write_yamlet}()}

Other conditionalize: 
\code{\link{conditionalize}()}
}
\concept{conditionalize}
\concept{interface}
