% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/orthoKMeansTrain.R
\name{orthoKMeansTrain}
\alias{orthoKMeansTrain}
\title{Orthogonal k-Means training.}
\usage{
orthoKMeansTrain(x = NULL, k = NULL, rounds = 1, iter.max = 100,
  init.type = "KMeans++", verbose = FALSE)
}
\arguments{
\item{x}{data to cluster}

\item{k}{number of centroids}

\item{rounds}{number of rounds/views for orthogonal kmeans}

\item{iter.max}{number of maximal iterations for each clustering}

\item{init.type}{string with method to initialize centroids}

\item{verbose}{show verbose messages?}
}
\value{
an S3 object containing the cluster labels for the training set as well as
	all necessary information for prediction.
}
\description{
\code{orthoKMeansTrain} will cluster a given data set into the specified number of
clusters. It can use either random initialization of the centroids or use KMeans++ for this.
The K-Means training itself is accelerated by using techniques by Greg Hamerly.
Orthoginality is implemented by using ideas from Cui et al 'Non-redudant multi-view
clustering via orthogonalization'.
}
\examples{
obj = yakmoR::orthoKMeansTrain (x = as.matrix(iris[seq(1,150,2),1:4]),
			k = 3, rounds = 3, verbose = TRUE)
}

