% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projdummies.R
\name{projdummies}
\alias{projdummies}
\title{Projection Dummies}
\usage{
projdummies(hhid, tid, w)
}
\arguments{
\item{hhid}{A vector of individual effect identifiers}

\item{tid}{A vector of time effect identifiers}

\item{w}{A vector of weights for each observation}
}
\value{
A list will be returned with necessary matrices to project upon.
   If the time effect has more levels, the matrices B, C, invDD, and invDDDH will be returned
   If the individual effect has more levels, the matrices A, B, invHH and invHHDH will be returned

   hhid and tid as factors will always be returned, as well as the original weights w that are passed.
}
\description{
\code{projdummies} returns necessary matrices to project variables on fixed effect dummies.
The input parameters all need to be of the same length.
}
\examples{
hhid <- c("a","b","c","a","b","c" ,"a","b","c" ,"a","b","c" ,"a","b","c")
tid <- c("1","1" ,"1" ,"2","2" ,"3","3","3" ,"4","4","5" ,"5","6","6" ,"6")
w <- rep(1, 15)
projdummies(hhid, tid, w)
}
