% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.pc.R
\name{cat.pc}
\alias{cat.pc}
\title{Categorical (visual) predictive check.}
\usage{
cat.pc(
  object,
  dv = xvardef("dv", object),
  idv = xvardef("idv", object),
  level.to.plot = NULL,
  subset = NULL,
  histo = T,
  median.line = F,
  PI.lines = F,
  xlb = if (histo) {
     paste("Proportion of ", dv)
 } else {
     paste(idv)
 },
  ylb = if (histo) {
     paste("Percent of Total")
 } else {
    
    paste("Proportion of Total")
 },
  main = xpose.create.title.text(NULL, dv, "Predictive check of", object, subset =
    subset, ...),
  strip = "Default",
  ...
)
}
\arguments{
\item{object}{Xpose data object.}

\item{dv}{The dependent variable (e.g. \code{"DV"} or \code{"CP"}.)}

\item{idv}{The independent variable (e.g. \code{"TIME"}.)}

\item{level.to.plot}{The levels to plot.}

\item{subset}{Subset of data.}

\item{histo}{If \code{FALSE} then a VPC is created, given that \code{idv} is
defined.}

\item{median.line}{Make a median line?}

\item{PI.lines}{Make prediction interval lines?}

\item{xlb}{Label for x axis.}

\item{ylb}{label for y axis.}

\item{main}{Main title.}

\item{strip}{Defining how the strips should appear in the conditioning
plots.}

\item{\dots}{Extra arguments passed to the function.}
}
\description{
Categorical (visual) predictive check plots.
}
\examples{

\dontrun{
## read in table files
runno <- 45
xpdb <- xpose.data(runno)

## create proportion (visual) predictive check
cat.pc(xpdb,idv=NULL)
cat.pc(xpdb,idv="DOSE")
cat.pc(xpdb,idv="DOSE",histo=F)
cat.pc(xpdb,idv="TIME",histo=T,level.to.plot=1)
}

}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew C. Hooker
}
\concept{specific functions}
\keyword{methods}
