% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dOFV1.vs.dOFV2.R
\name{dOFV1.vs.dOFV2}
\alias{dOFV1.vs.dOFV2}
\title{Change in individual objective function value 1 vs. individual objective
function value 2.}
\usage{
dOFV1.vs.dOFV2(
  xpdb1,
  xpdb2,
  xpdb3,
  ylb = expression(paste(Delta, OFV1[i])),
  xlb = expression(paste(Delta, OFV2[i])),
  main = "Default",
  smooth = NULL,
  abline = c(0, 1),
  ablcol = "grey",
  abllwd = 2,
  abllty = "dashed",
  lmline = TRUE,
  ...
)
}
\arguments{
\item{xpdb1}{Xpose data object for first NONMEM run}

\item{xpdb2}{Xpose data object for second NONMEM run}

\item{xpdb3}{Xpose data object for third NONMEM run}

\item{ylb}{Label for Y axis.}

\item{xlb}{Label for X axis.}

\item{main}{Title of plot.}

\item{smooth}{Should we have a smooth?}

\item{abline}{abline description.}

\item{ablcol}{color of abline}

\item{abllwd}{line width of abline}

\item{abllty}{type of abline}

\item{lmline}{Linear regression line?}

\item{\dots}{Additional arguments to function.}
}
\description{
Change in individual objective function value 1 vs. individual objective
}
\examples{

\dontrun{
## read in table files
xpdb8 <- xpose.data(8)
xpdb8 <- xpose.data(9)
xpdb11 <- xpose.data(11)

## Make the plot
dOFV.vs.cov(xpdb8,xpdb9,xpdb11)
}

}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew C. Hooker
}
\concept{specific functions}
\keyword{methods}
