% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dOFV.vs.id.R
\name{dOFV.vs.id}
\alias{dOFV.vs.id}
\title{Change in Objective function value vs. removal of individuals.}
\usage{
dOFV.vs.id(
  xpdb1,
  xpdb2,
  sig.drop = -3.84,
  decrease.label.number = 3,
  increase.label.number = 3,
  id.lab.cex = 0.6,
  id.lab.pos = 2,
  type = "o",
  xlb = "Number of subjects removed",
  ylb = expression(paste(Delta, "OFV")),
  main = "Default",
  sig.line.col = "red",
  sig.line.lty = "dotted",
  tot.line.col = "grey",
  tot.line.lty = "dashed",
  key = list(columns = 1, lines = list(pch = c(super.sym$pch[1:2], NA, NA), type =
    list("o", "o", "l", "l"), col = c(super.sym$col[1:2], sig.line.col, tot.line.col), lty
    = c(super.sym$lty[1:2], sig.line.lty, tot.line.lty)), text =
    list(c(expression(paste(Delta, OFV[i] < 0)), expression(paste(Delta, OFV[i] > 0)),
    expression(paste("Significant  ", Delta, OFV)), expression(paste("Total  ", Delta,
    OFV)))), corner = c(0.95, 0.5), border = T),
  ...
)
}
\arguments{
\item{xpdb1}{Xpose data object for first NONMEM run ("new" run)}

\item{xpdb2}{Xpose data object for Second NONMEM run ("reference" run)}

\item{sig.drop}{What is a significant drop of OFV?}

\item{decrease.label.number}{How many points should bw labeled with ID
values for those IDs with a drop in iOFV?}

\item{increase.label.number}{How many points should bw labeled with ID
values for those IDs with an increase in iOFV?}

\item{id.lab.cex}{Size of ID labels.}

\item{id.lab.pos}{ID label position.}

\item{type}{Type of lines.}

\item{xlb}{X-axis label.}

\item{ylb}{Y-axis label.}

\item{main}{Title of plot.}

\item{sig.line.col}{Significant OFV drop line color.}

\item{sig.line.lty}{Significant OFV drop line type.}

\item{tot.line.col}{Total OFV drop line color.}

\item{tot.line.lty}{Total OFV drop line type.}

\item{key}{Legend for plot.}

\item{\dots}{Additional arguments to function.}
}
\description{
A plot showing the most and least influential individuals in determining a
drop in OFV between two models.
}
\examples{

\dontrun{
library(xpose4)

## first make sure that the iofv values are read into xpose
cur.dir <- getwd()
setwd(paste(cur.dir,"/LAG_TIME",sep=""))
xpdb1 <- xpose.data(1)
setwd(paste(cur.dir,"/TRANSIT_MODEL",sep=""))
xpdb2 <- xpose.data(1)
setwd(cur.dir)

## then make the plot
dOFV.vs.id(xpdb1,xpdb2)
}

}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres_wres_vs_x}},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew C. Hooker
}
\concept{specific functions}
\keyword{methods}
